/**
 * 	rmFx_msgTagging.js
 *
 	supports Thunderbird/MailApp messages tagging
	@since
		2009-11-01		SM2 support
		2009-07-27		TB2/TB3/PB support
<br>	2009-03-04		tag now can have uppercase letters, not sorted to top of list anymore
<br>	2008-04-14		deleting tag from message was adding it to the general tag-list
<br>	2011-01			PB2 rewrite
 */

function rmFx_msgTAGing(tagName, tagOp, tagColor, messageDBHDR) {

			var tagService = Components.classes["@mozilla.org/messenger/tagservice;1"]
		                         .getService(Components.interfaces.nsIMsgTagService);                                    
			var xKey = tagService.getKeyForTag(tagName); 

			// add the tag to the tag-list if not already exists
			if (!!xKey == false) { 
 			  	 tagService.addTag(tagName, tagColor, '', true );	//  3. param is 'ordinal', leave blank
															//  4. param is PostBox addition 
			}
			
			if (messageDBHDR == null) { // if NO Hdr data, then used standard ToggleMessageTag
				ToggleMessageTag(xKey, tagOp, "", false)  // use tagName to get key, third param for PB
			} else { 	  //  else, we have the msg-URI
				rmFx_msgTagwHdr(xKey, tagOp, messageDBHDR)
			}
}

   /**
    *  'tag' ONE msg, if the msgHdr is known
    *  
<br>*  //		 messageDBHDR.messageKey = [integer] 1499427
<br>*  //		 selectedMsgUris[0] = [string] "mailbox-message://nobody@Local%20Folders/Sent#1499427"
    */
function rmFx_msgTagwHdr(key, addKey, messageHdr) {
           if (gRmFx_Messenger != "PB") {
              rmFx_msgTagwHdrTB(key, addKey, messageHdr)
           } else {
              rmFx_msgTagwHdrPB(key, addKey, messageHdr)
           }
}

function rmFx_msgTagwHdrTB(key, addKey, messageHdr)
{
   var messages = Components.classes["@mozilla.org/array;1"].createInstance(Components.interfaces.nsIMutableArray);
   var msg = Components.classes["@mozilla.org/array;1"].createInstance(Components.interfaces.nsIMutableArray);

   var toggler = addKey ? "addKeywordsToMessages" : "removeKeywordsFromMessages";
   var prevHdrFolder = null;

    var msgHdr = messageHdr;
    if (msgHdr.label) {
      // Since we touch all these messages anyway, migrate the label now.
      // If we don't, the thread tree won't always show the correct tag state,
      // because resetting a label doesn't update the tree anymore...
      msg.clear();
      msg.appendElement(msgHdr, false);
      msgHdr.folder.addKeywordsToMessages(msg, "$label" + msgHdr.label);
      msgHdr.label = 0; // remove legacy label
    }
    if (prevHdrFolder != msgHdr.folder) {
      if (prevHdrFolder)
        prevHdrFolder[toggler](messages, key, false);
      messages.clear();
      prevHdrFolder = msgHdr.folder;
    }
    messages.appendElement(msgHdr, false);

  if (prevHdrFolder)
    prevHdrFolder[toggler](messages, key, false);
  
           var messg = "FolderListener: rmFx_msgTagwHdr: key:" + key 
               + "\ntoggler: " + toggler  + "\nmsgHdr.label:" + msgHdr.label
               + "\nmessages:" + messages
               ;
            rmFxUtil.dump2Console ('FolderListener', messg);
}

function rmFx_msgTagwHdrPB (key, addKey, messageHdr)
{    
   var slam = false;
   
   var globalIndex = Cc['@mozilla.org/msg-global-index;1'].getService(Ci.nsIMsgGlobalIndex);
   var messages = Components.classes["@mozilla.org/supports-array;1"].
                               createInstance(Components.interfaces.nsISupportsArray);
   var toggler = addKey ? "addKeywordsToMessages" : "removeKeywordsFromMessages";
   var prevHdrFolder = null;
    var msgHdr = messageHdr;
    if (msgHdr.label)
    {
      // Since we touch all these messages anyway, migrate the label now.
      // If we don't, the thread tree won't always show the correct tag state,
      // because resetting a label doesn't update the tree anymore...
      var msgs = Components.classes["@mozilla.org/supports-array;1"].
                            createInstance(Components.interfaces.nsISupportsArray);
      msgs.AppendElement(msgHdr);
      msgHdr.folder.addKeywordsToMessages(msgs, "$label" + msgHdr.label, slam);
      msgHdr.label = 0; // remove legacy label
   }

   if (prevHdrFolder != msgHdr.folder)
   {
      if (prevHdrFolder)
      {
        prevHdrFolder[toggler](messages, key, slam);
      }
      messages.Clear();
      prevHdrFolder = msgHdr.folder;
   }
   messages.AppendElement(msgHdr);

   if (prevHdrFolder)
   {
      prevHdrFolder[toggler](messages, key, false);
   }
}
